<?php

// initialize database and global variables
include_once('functions.php');

// obtain the current user from the GET parameter and load their internal ID
$username = $_GET["user"];
$users = $conn->Execute("SELECT user_id FROM user WHERE username like ?", array($username));

// handle coupon redemption
if (!empty($_POST["hiddenUserID"]) && !empty($_POST["hiddenCouponID"])){
	// redeem the coupon within the database
	$conn->Execute("UPDATE coupon_user
			SET is_redeemed = true
			WHERE coupon_id = ?
				AND to_user_id = ?", array($_POST["hiddenCouponID"], $_POST["hiddenUserID"]));
	$redeemedCoupon = $conn->Execute("SELECT ufrom.username as fromUser, uto.username as toUser, coupon.name, coupon.description
			FROM coupon_user
			INNER JOIN user ufrom ON coupon_user.from_user_id = ufrom.user_id
			INNER JOIN user uto ON coupon_user.to_user_id = uto.user_id
			INNER JOIN coupon ON coupon.coupon_id = coupon_user.coupon_id
			WHERE coupon_user.coupon_id = ?
				AND coupon_user.to_user_id = ? ", array($_POST["hiddenCouponID"], $_POST["hiddenUserID"]));
	// attempt to mail a message to chris.the.stinson@gmail.com
	$to = "chris.the.stinson@gmail.com";
	$subject = "Coupon Redemption";
	$message = "Dear Mr. Christopher Stinson,
			
It has come to our attention that a user has opted to redeem a coupon through the Coupon Distribution Network.

Coupon details are as follows:

	Coupon name: " . $redeemedCoupon->fields["name"] . "
	Coupon description: " . $redeemedCoupon->fields["description"] . "
	Recipient: " . $redeemedCoupon->fields["toUser"] . "
	Provider: " . $redeemedCoupon->fields["fromUser"] . "
					
As the Grandmaster of Excellence, please follow up with the intended recipient and/or provider as you see fit, so as to facilitate the smooth execution of this redemption.

Sincerely,
Coupon Distribution Network";
	try{
		mail($to, $subject, $message);
	}
	catch(Exception $e) {print $e->getMessage();}
}

?>
<!DOCTYPE HTML>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html">
		<title>Coupon Deployment Network</title>
		<script src="//ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
		<script src="//ajax.googleapis.com/ajax/libs/jqueryui/1.11.1/jquery-ui.min.js"></script>
		<script src="snow.js"></script>
		<link rel="stylesheet" href="styles.css" type="text/css">
		<link rel="stylesheet" href="http://ajax.googleapis.com/ajax/libs/jqueryui/1.11.1/themes/cupertino/jquery-ui.css" type="text/css">
	</head>
	<body>
		<canvas id="canvas"></canvas>
		<form id="frmMain" name="frmMain" method="post">
			<?if ($users && !$users->EOF){
				$userID = $users->fields["user_id"];?>
				<script type="text/javascript" language="JavaScript">
					// initialize the javascript array of coupon animations and define functions
					var couponAnimationInProgress = [];
					var userID = <?=$userID?>;
	
					function configureCoupon(couponID){
						// show the coupon content whenever the user hovers over the cover (unless an animation is already in progress)
					    $("#cover" + couponID)
					    	.mouseenter(
					    		function() {
					  	    		if (!couponAnimationInProgress[couponID]){
					  	    			runCouponAnimation(couponID, "show", "easeOutBounce");
					  	    		}
					    		});
						// hide the coupon whenever the user moves the mouse away from this coupon (cover or content)
					  	$("#coupon" + couponID)
							.mouseleave(
								function() {
									runCouponAnimation(couponID, "hide", "easeInBounce");
								});
					  	$("#redeem" + couponID)
						  	.button()
						    	.click(function( event ) {
						     		event.preventDefault();
						     		// post back the page, redeeming this coupon on page load
						     		if (confirm("Are you sure you wish to redeem this coupon now?")){
						     			document["frmMain"].hiddenUserID.value = userID;
							     		document["frmMain"].hiddenCouponID.value = couponID;
						     			document["frmMain"].submit();
						     		}
						    	});
					};
	
					function runCouponAnimation(couponID, animationType, easingType){
						couponAnimationInProgress[couponID] = true;
						$("#content" + couponID).animate({height: animationType}, 1600, easingType, function(){
							couponAnimationInProgress[couponID] = false;
						});
					}
				</script>
				<?$coupons = $conn->Execute("SELECT coupon.coupon_id, name, description, is_redeemed
						FROM coupon
						INNER JOIN coupon_user ON coupon_user.coupon_id = coupon.coupon_id
						WHERE to_user_id = ?
						ORDER BY is_redeemed, coupon.coupon_id", array($userID));
				foreach($coupons as $rowNum => $coupon) {
					$strClass = "";
					$strDisabled = "";
					if ($coupon["is_redeemed"]){
						$strClass = "redeemed";
						$strDisabled = "disabled";
					}?>
				<div id="coupon<?=$coupon["coupon_id"]?>" class="coupon">
					<div id="cover<?=$coupon["coupon_id"]?>" class="cover">
						<div class="center <?=$strClass?>">
							<?=$coupon["name"]?>
						</div>
					</div>
					<div id="content<?=$coupon["coupon_id"]?>" class="content">
						<div class="center <?=$strClass?>">
							<?=$coupon["description"]?>
						</div>
						<button id="redeem<?=$coupon["coupon_id"]?>" <?=$strDisabled?>>Redeem</button>
					</div>
				</div>
				<script type="text/javascript" language="JavaScript">
					couponAnimationInProgress[<?=$coupon["coupon_id"]?>] = false;
					configureCoupon(<?=$coupon["coupon_id"]?>);
				</script>
				<?}
			}
			else {?>
				<div>Sorry, no coupons found for you!</div>
			<?}?>
			<input type="hidden" id="hiddenUserID" name="hiddenUserID" value="">
			<input type="hidden" id="hiddenCouponID" name="hiddenCouponID" value="">
		</form>
	</body>
</html>